/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/

var STBPluginJSSocials = Object.create(STBModule.prototype);

STBPluginJSSocials.name = "PluginTyped";

STBPluginJSSocials.initPlugin = function() {
	
	var elements = jQuery("[data-jssocials]:not(.__done)");

	if (elements.length) {

		elements.each(function() {
			var obj = jQuery(this),
				options = {
					text		: STBUtils.attrDefaultValue(obj.attr("data-jssocials-text"), ""),
					url			: STBUtils.attrDefaultValue(obj.attr("data-jssocials-url"), ""),
					showLabel	: STBUtils.attrDefaultValue(obj.attr("data-jssocials-label"), false),
					showCount	: STBUtils.attrDefaultValue(obj.attr("data-jssocials-count"), false),
					shares		: STBUtils.attrDefaultValue(obj.attr("data-jssocials-networks"), "").split(",")
				};

			obj.jsSocials(options);
			obj.addClass("__done");
		});
	}
}

STBPluginJSSocials.runOnReady = function() {
	STBPluginJSSocials.initPlugin();
}

STBPluginJSSocials.runOnContentUpdate = function() {
	STBPluginJSSocials.initPlugin();
}

site.registerModule(STBPluginJSSocials);